USE [master]
GO
-- CREATE DATABASE GENISIS_DB (MAKE SURE YOU CHANGE THE PATH OF DATA AND LOG FILES)--

CREATE DATABASE [GENISIS_DB]
 CONTAINMENT = NONE
 ON  PRIMARY 
( NAME = N'GENISIS_DB', FILENAME = N'D:\SQLData\Genisis_Db_data.mdf' , SIZE = 4096KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
 LOG ON 
( NAME = N'GENISIS_DB_log', FILENAME = N'D:\SQLLogs\GENISIS_DB_log.ldf' , SIZE = 4224KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
GO
ALTER DATABASE [GENISIS_DB] SET COMPATIBILITY_LEVEL = 110
GO
IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
EXEC [GENISIS_DB].[dbo].[sp_fulltext_database] @action = 'enable'
end
GO
ALTER DATABASE [GENISIS_DB] SET ANSI_NULL_DEFAULT OFF 
GO
ALTER DATABASE [GENISIS_DB] SET ANSI_NULLS OFF 
GO
ALTER DATABASE [GENISIS_DB] SET ANSI_PADDING OFF 
GO
ALTER DATABASE [GENISIS_DB] SET ANSI_WARNINGS OFF 
GO
ALTER DATABASE [GENISIS_DB] SET ARITHABORT OFF 
GO
ALTER DATABASE [GENISIS_DB] SET AUTO_CLOSE OFF 
GO
ALTER DATABASE [GENISIS_DB] SET AUTO_CREATE_STATISTICS ON 
GO
ALTER DATABASE [GENISIS_DB] SET AUTO_SHRINK OFF 
GO
ALTER DATABASE [GENISIS_DB] SET AUTO_UPDATE_STATISTICS ON 
GO
ALTER DATABASE [GENISIS_DB] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO
ALTER DATABASE [GENISIS_DB] SET CURSOR_DEFAULT  GLOBAL 
GO
ALTER DATABASE [GENISIS_DB] SET CONCAT_NULL_YIELDS_NULL OFF 
GO
ALTER DATABASE [GENISIS_DB] SET NUMERIC_ROUNDABORT OFF 
GO
ALTER DATABASE [GENISIS_DB] SET QUOTED_IDENTIFIER OFF 
GO
ALTER DATABASE [GENISIS_DB] SET RECURSIVE_TRIGGERS OFF 
GO
ALTER DATABASE [GENISIS_DB] SET  DISABLE_BROKER 
GO
ALTER DATABASE [GENISIS_DB] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO
ALTER DATABASE [GENISIS_DB] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO
ALTER DATABASE [GENISIS_DB] SET TRUSTWORTHY OFF 
GO
ALTER DATABASE [GENISIS_DB] SET ALLOW_SNAPSHOT_ISOLATION OFF 
GO
ALTER DATABASE [GENISIS_DB] SET PARAMETERIZATION SIMPLE 
GO
ALTER DATABASE [GENISIS_DB] SET READ_COMMITTED_SNAPSHOT OFF 
GO
ALTER DATABASE [GENISIS_DB] SET HONOR_BROKER_PRIORITY OFF 
GO
ALTER DATABASE [GENISIS_DB] SET RECOVERY FULL 
GO
ALTER DATABASE [GENISIS_DB] SET  MULTI_USER 
GO
ALTER DATABASE [GENISIS_DB] SET PAGE_VERIFY CHECKSUM  
GO
ALTER DATABASE [GENISIS_DB] SET DB_CHAINING OFF 
GO
ALTER DATABASE [GENISIS_DB] SET FILESTREAM( NON_TRANSACTED_ACCESS = OFF ) 
GO
ALTER DATABASE [GENISIS_DB] SET TARGET_RECOVERY_TIME = 0 SECONDS 
GO
EXEC sys.sp_db_vardecimal_storage_format N'GENISIS_DB', N'ON'
GO

--CREATE APP USER FOR GENISIS_DB--

CREATE LOGIN [genisis]
    WITH PASSWORD = N'admin123';

GO
CREATE USER [genisis] FOR LOGIN [genisis];

GO
GRANT CONNECT TO [genisis]
    AS [dbo];
	 
EXEC sp_addrolemember N'db_datareader', N'genisis'

EXEC sp_addrolemember N'db_datawriter', N'genisis'

--CREATE STORED PROC FOR USER_CREATION--
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROC [dbo].[Usp_Insert_Usermgt]

(@User_id VARCHAR(320), 
@First_Name VARCHAR(50), 
@Middle_Name VARCHAR(50), 
@Last_Name VARCHAR(50), 
@user_approver_id varchar(320), 
@Role_Type_id int, 
@User_Type_id int
)
 as

SET NOCOUNT ON
SET XACT_ABORT ON

 BEGIN
BEGIN TRANSACTION
BEGIN TRY

        insert into dbo.Users
        (User_id,First_Name,Middle_Name,Last_Name,Create_Date,Email_id,User_Active,Active_date,Inactive_date) 
        values 
        (@User_id,@First_Name,@Middle_Name,@Last_Name,GETDATE(),@User_id,1,GETDATE(),null)


		DECLARE @id int
		SET @Id = (Select max(Id) from User_Role_Type)+1
             
   
INSERT [dbo].[User_Role_Type] ([Id], [Role_Type_id], [User_Type_id], [User_id], [Start_Date], [End_Date]) VALUES
 (@Id,@Role_Type_id,@User_Type_id,@User_id,GETDATE(),null)
    

	DECLARE @NEW_ID int
	SET @NEW_ID = (Select max(Id) from User_Approver)+1

  INSERT [dbo].[User_Approver] ([Id], [User_id], [User_Approver_id])
  VALUES(@NEW_ID,@User_id,@user_approver_id)

  COMMIT;

  SELECT 'USER CREATED SUCCESSFULLY' AS MESSAGE

 END TRY

BEGIN CATCH
			ROLLBACK;
			SELECT 'User not Created' AS MESSAGE
END CATCH

END
 



GO


--CREATE TABLES--

/****** Object:  Table [dbo].[CommentHistory]    Script Date: 5/23/2017 3:43:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[CommentHistory](
	[CommentId] [int] NOT NULL,
	[RequestId] [int] NOT NULL,
	[StatusId] [int] NOT NULL,
	[Comments] [varchar](3000) NULL,
	[CreatedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[TYPE] [varchar](6) NULL,
	[TaskId] [varchar](50) NULL,
 CONSTRAINT [PK_CommentHistory] PRIMARY KEY CLUSTERED 
(
	[CommentId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Management_table]    Script Date: 5/23/2017 3:43:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Management_table](
	[ReqID] [int] NULL,
	[DatabaseName] [varchar](50) NULL,
	[CopyStatus] [varchar](25) NULL,
	[dateandtime] [datetime] NULL,
	[checksum_before_copy] [bigint] NULL,
	[checksum_after_copy] [bigint] NULL,
	[Table_Name] [varchar](50) NULL,
	[rowcount_before_copy] [int] NULL,
	[rowcount_after_copy] [int] NULL,
	[status_before_copy] [varchar](20) NULL,
	[status_after_copy] [varchar](20) NULL
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Request]    Script Date: 5/23/2017 3:43:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Request](
	[Id] [int] NOT NULL,
	[ProcessId] [int] NOT NULL,
	[Title] [varchar](256) NULL,
	[Description] [varchar](3000) NULL,
	[ApprovalStatus] [varchar](50) NULL,
	[DetailesInternalStatusCode] [varchar](50) NULL,
	[StatusDescription] [varchar](50) NULL,
	[RequestType] [int] NOT NULL,
	[Source] [int] NOT NULL,
	[NotifyCollaboraters] [tinyint] NULL,
	[AssociatedRequest1] [int] NULL,
	[AssociatedRequest2] [int] NULL,
	[AssociatedRequest3] [int] NULL,
	[StudyApproval] [int] NOT NULL,
	[CreatedOn] [datetime] NULL,
	[ModifiedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[ModifiedBy] [varchar](50) NULL,
	[ApproverId] [varchar](50) NULL,
	[TaskId] [varchar](50) NULL,
 CONSTRAINT [PK_Request] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[RequestHistory]    Script Date: 5/23/2017 3:43:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[RequestHistory](
	[HistLineNo] [int] NOT NULL,
	[Id] [int] NOT NULL,
	[ProcessId] [int] NOT NULL,
	[Title] [varchar](256) NULL,
	[Description] [varchar](3000) NULL,
	[ApprovalStatus] [varchar](50) NULL,
	[DetailesInternalStatusCode] [varchar](50) NULL,
	[StatusDescription] [varchar](50) NULL,
	[RequestType] [int] NOT NULL,
	[Source] [int] NOT NULL,
	[NotifyCollaboraters] [tinyint] NULL,
	[AssociatedRequest1] [int] NULL,
	[AssociatedRequest2] [int] NULL,
	[AssociatedRequest3] [int] NULL,
	[StudyApproval] [int] NOT NULL,
	[CreatedOn] [datetime] NULL,
	[ModifiedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[ModifiedBy] [varchar](50) NULL,
	[ApproverId] [varchar](50) NULL,
	[TaskId] [varchar](50) NULL,
 CONSTRAINT [PK_RequestHistory] PRIMARY KEY CLUSTERED 
(
	[HistLineNo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[RequestType]    Script Date: 5/23/2017 3:43:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[RequestType](
	[Id] [int] NOT NULL,
	[Description] [varchar](50) NULL,
 CONSTRAINT [PK_RequestType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Role_Type]    Script Date: 5/23/2017 3:43:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Role_Type](
	[Role_Type_id] [int] NOT NULL,
	[Role_Name] [varchar](50) NOT NULL,
	[Role_Description] [varchar](50) NOT NULL,
 CONSTRAINT [Role_Type_pk] PRIMARY KEY CLUSTERED 
(
	[Role_Type_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Source]    Script Date: 5/23/2017 3:43:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Source](
	[Id] [int] NOT NULL,
	[Description] [varchar](50) NULL,
 CONSTRAINT [PK_Source] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[StudyApproval]    Script Date: 5/23/2017 3:43:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[StudyApproval](
	[Id] [int] NOT NULL,
	[ProcessId] [int] NOT NULL,
	[ApprovalIdObtained] [varchar](3000) NULL,
	[AssociatedStudyApproval1] [int] NULL,
	[AssociatedStudyApproval2] [int] NULL,
	[AssociatedStudyApproval3] [int] NULL,
	[Title] [varchar](50) NULL,
	[Description] [varchar](3000) NULL,
	[CreatedOn] [datetime] NULL,
	[ModifiedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[ModifiedBy] [varchar](50) NULL,
 CONSTRAINT [PK_StudyApproval] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[User_Approver]    Script Date: 5/23/2017 3:43:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[User_Approver](
	[Id] [int] NOT NULL,
	[User_id] [varchar](320) NOT NULL,
	[User_Approver_id] [varchar](320) NOT NULL,
 CONSTRAINT [User_Approver_pk] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[User_Role_Type]    Script Date: 5/23/2017 3:43:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[User_Role_Type](
	[Id] [int] NOT NULL,
	[Role_Type_id] [int] NOT NULL,
	[User_Type_id] [int] NOT NULL,
	[User_id] [varchar](320) NOT NULL,
	[Start_Date] [datetime] NOT NULL,
	[End_Date] [datetime] NULL,
 CONSTRAINT [User_Role_Type_pk] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[User_Type]    Script Date: 5/23/2017 3:43:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[User_Type](
	[User_Type_id] [int] NOT NULL,
	[User_Type_desc] [varchar](50) NOT NULL,
 CONSTRAINT [User_Type_pk] PRIMARY KEY CLUSTERED 
(
	[User_Type_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Users]    Script Date: 5/23/2017 3:43:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Users](
	[User_id] [varchar](320) NOT NULL,
	[First_Name] [varchar](50) NOT NULL,
	[Middle_Name] [varchar](50) NULL,
	[Last_Name] [varchar](50) NOT NULL,
	[Last_Name2] [varchar](50) NULL,
	[Create_Date] [datetime] NOT NULL,
	[Email_id] [varchar](320) NOT NULL,
	[User_Active] [tinyint] NOT NULL,
	[Active_date] [datetime] NOT NULL,
	[Inactive_date] [datetime] NULL,
 CONSTRAINT [User_pk] PRIMARY KEY CLUSTERED 
(
	[User_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[WorkflowStatus]    Script Date: 5/23/2017 3:43:34 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[WorkflowStatus](
	[Id] [int] NOT NULL,
	[Description] [varchar](50) NULL,
 CONSTRAINT [PK_WorkflowStatus] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
ALTER TABLE [dbo].[CommentHistory]  WITH CHECK ADD  CONSTRAINT [FK_CommentHistory_Request] FOREIGN KEY([RequestId])
REFERENCES [dbo].[Request] ([Id])
GO
ALTER TABLE [dbo].[CommentHistory] CHECK CONSTRAINT [FK_CommentHistory_Request]
GO
ALTER TABLE [dbo].[CommentHistory]  WITH CHECK ADD  CONSTRAINT [FK_CommentHistory_WorkflowStatus] FOREIGN KEY([StatusId])
REFERENCES [dbo].[WorkflowStatus] ([Id])
GO
ALTER TABLE [dbo].[CommentHistory] CHECK CONSTRAINT [FK_CommentHistory_WorkflowStatus]
GO
ALTER TABLE [dbo].[RequestHistory]  WITH CHECK ADD  CONSTRAINT [FK_RequestHistory_Request] FOREIGN KEY([Id])
REFERENCES [dbo].[Request] ([Id])
GO
ALTER TABLE [dbo].[RequestHistory] CHECK CONSTRAINT [FK_RequestHistory_Request]
GO
ALTER TABLE [dbo].[User_Approver]  WITH CHECK ADD  CONSTRAINT [User_Approver_User] FOREIGN KEY([User_id])
REFERENCES [dbo].[Users] ([User_id])
GO
ALTER TABLE [dbo].[User_Approver] CHECK CONSTRAINT [User_Approver_User]
GO
ALTER TABLE [dbo].[User_Approver]  WITH CHECK ADD  CONSTRAINT [User_Approver_User_id] FOREIGN KEY([User_Approver_id])
REFERENCES [dbo].[Users] ([User_id])
GO
ALTER TABLE [dbo].[User_Approver] CHECK CONSTRAINT [User_Approver_User_id]
GO
ALTER TABLE [dbo].[User_Role_Type]  WITH CHECK ADD  CONSTRAINT [FK_Type_User] FOREIGN KEY([User_id])
REFERENCES [dbo].[Users] ([User_id])
GO
ALTER TABLE [dbo].[User_Role_Type] CHECK CONSTRAINT [FK_Type_User]
GO
ALTER TABLE [dbo].[User_Role_Type]  WITH CHECK ADD  CONSTRAINT [FK_User_typeID] FOREIGN KEY([User_Type_id])
REFERENCES [dbo].[User_Type] ([User_Type_id])
GO
ALTER TABLE [dbo].[User_Role_Type] CHECK CONSTRAINT [FK_User_typeID]
GO
ALTER TABLE [dbo].[User_Role_Type]  WITH CHECK ADD  CONSTRAINT [User_Role_Type_Role_Type] FOREIGN KEY([Role_Type_id])
REFERENCES [dbo].[Role_Type] ([Role_Type_id])
GO
ALTER TABLE [dbo].[User_Role_Type] CHECK CONSTRAINT [User_Role_Type_Role_Type]
GO
USE [master]
GO
ALTER DATABASE [GENISIS_DB] SET  READ_WRITE 
GO



--LOAD FOR LOOKUP TABLES--



USE [GENISIS_DB]
GO

INSERT INTO [dbo].[Source]([Id],[Description]) VALUES (1  ,'Survey');
INSERT INTO [dbo].[Source]([Id],[Description]) VALUES (2  ,'Genomic');
INSERT INTO [dbo].[Source]([Id],[Description]) VALUES (3  ,'Clinical Data');

GO


USE [GENISIS_DB]
GO

INSERT INTO [dbo].[RequestType]([Id],[Description]) VALUES (1  ,'Aggregate');
INSERT INTO [dbo].[RequestType]([Id],[Description]) VALUES (2  ,'DetailRecords');

GO


USE [GENISIS_DB]
GO

INSERT INTO [dbo].[StudyApproval] ([Id] ,[ProcessId] ,[Title],[Description])  VALUES  (1,0,'csp572', 'csp572');
INSERT INTO [dbo].[StudyApproval] ([Id] ,[ProcessId] ,[Title],[Description])  VALUES  (2,0,'mvp001', 'mvp001');
INSERT INTO [dbo].[StudyApproval] ([Id] ,[ProcessId] ,[Title],[Description])  VALUES  (3,0,'mvp002', 'mvp002');
INSERT INTO [dbo].[StudyApproval] ([Id] ,[ProcessId] ,[Title],[Description])  VALUES  (4,0,'mvp003', 'mvp003');
INSERT INTO [dbo].[StudyApproval] ([Id] ,[ProcessId] ,[Title],[Description])  VALUES  (5,0,'mvp004', 'mvp004');
INSERT INTO [dbo].[StudyApproval] ([Id] ,[ProcessId] ,[Title],[Description])  VALUES  (6,0,'mvp005', 'mvp005');
INSERT INTO [dbo].[StudyApproval] ([Id] ,[ProcessId] ,[Title],[Description])  VALUES  (7,0,'csp575b', 'csp575b');

GO


USE [GENISIS_DB]
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (1, N'Draft')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (2, N'Submitted')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (3, N'Denied')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (4, N'Returned')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (5, N'Sent')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (6, N'Update')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (7, N'RequestAccepted')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (8, N'RequestNotAccepted')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (9, N'ResultsAccepted')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (10, N'ResultsNotAccepted')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (11, N'ResultsDelivered')
GO



USE [GENISIS_DB]
GO

INSERT INTO [dbo].[User_Type] ([User_Type_id] ,[User_Type_desc])  VALUES   (1, 'Contractor');
INSERT INTO [dbo].[User_Type] ([User_Type_id] ,[User_Type_desc])  VALUES   (2, 'Employee');
GO


USE [GENISIS_DB]
GO

INSERT INTO [dbo].[Role_Type]  ([Role_Type_id]  ,[Role_Name] ,[Role_Description])  VALUES (1  ,'Administrator'  ,'Administrator');
INSERT INTO [dbo].[Role_Type]  ([Role_Type_id]  ,[Role_Name] ,[Role_Description])  VALUES (2  ,'Researcher'  ,'Researcher');
INSERT INTO [dbo].[Role_Type]  ([Role_Type_id]  ,[Role_Name] ,[Role_Description])  VALUES (3  ,'Data Destination Manager'  ,'Data Destination Manager');
INSERT INTO [dbo].[Role_Type]  ([Role_Type_id]  ,[Role_Name] ,[Role_Description])  VALUES (4  ,'Data Source Manager'  ,'Data Source Manager');
GO
